#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//doodlenoodleMod01.fsh   by   sophia_the_idea
//https://www.shadertoy.com/view/....
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    
    vec2 uv = (fragCoord-.5*iResolution.xy)/iResolution.y;
   //vec3 col2 = 0.5 + 0.5*cos(iTime+uv.xyx+vec3(8,2,4));

float t = iTime*.2; //animation
uv *= mat2(cos(t), -sin(t), sin(t), cos(t));
   //camera code
   vec3 ro = vec3(0,0,-1); //third number is ground plane, -1 get u in middle bc of other -1
   vec3 lookat = mix(vec3(0), vec3(-1, 0, -1), sin(t*1.56)*.5+.5); //looks at orgin
   float zoom = mix(.2, .7, sin(t)*.5+.5);
   
   //direction three axis for camera c is center
   vec3 f = normalize(lookat-ro),
       r = normalize(cross(vec3(0,1,0), f)),
       u = cross(f, r),
       c = ro + f * zoom, 
       i = c + uv.x * r + uv.y * u,
       rd = normalize(i-ro);
   
   float radius = mix(.3, 1.5, sin(t*.4)*.5+.5);;
   float ds, dO; 
   vec3 p;
   
   for(int i =0; i<100; i++){
   p = ro +rd * dO;
   ds = -(length(vec2(length(p.xz)-1., p.y)) - radius); //size of tube
                                                    //made donut -.5 is radus - is making it inverted
   if(ds<.001) break;
   dO += ds;
   }
    vec3 col = vec3(0);

   if(ds < .001) {
   float x = atan(p.x, p.z)+t*.5; //pi to pi //adding t here makes the texture rotate
   float y = atan(length(p.xz)-1., p.y);
   
   float bands = sin(y*10.+x*20.); //makes sqirly donut Ito make swist add x and multi by whole number)
   float ripples = sin((x*10.-y*30.)*3.)*.5+.5; //*3 makes frequency of rips higher
   float waves = sin(x*2.-y*6.+t*20.);
  
  float b1 = smoothstep(-1., 1., bands); //makes lines harder
  float b2 = smoothstep(-.2, .2, bands-.5); //makes white part more narrow
  float m = b1*(1.-b2); //makes so you just have edges
  m += max(m, ripples*b2*max(0., waves)); //shows ripples inside of the groove
  m += max(0., waves*.3*b2);
  
  
  
  col += mix(m, 1.-m, smoothstep(-.3, .3, sin(x*2.+t))); //if you enter in a different varible it changes what ou see
   }
    
   fragColor = vec4(col, 1.0);
   //fragColor = vec4(0.5 + 0.5 * col, 1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

